package org.sc3d.apt.jrider.v1;

/** Represents the position of a camera, and the direction in which it is looking. A Camera must be level, but may rotate about the direction in which it is looking. Instances are immutable. */
public class Camera {
  /** Constructs an upright Camera, given values for its fields. */
  public Camera(int x, int y, int z, int wx, int wy) {
    this.x = x; this.y = y; this.z = z;
    this.wx = wx; this.wy = wy;
    this.sin = 0<<16; this.cos = 1<<16;
  }
  
  /** Constructs a rotated Camera, given values for its fields. */
  public Camera(int x, int y, int z, int wx, int wy, int sin, int cos) {
    this.x = x; this.y = y; this.z = z;
    this.wx = wx; this.wy = wy;
    this.sin = sin; this.cos = cos;
  }
  
  /* New API. */
  
  /** The x-coordinate (east) of this Camera, in units such that the size of the landscape is '1&lt;&lt;32' (so 1 metre is '1&lt;&lt;22'). */
  public final int x;

  /** The y-coordinate (north) of this Camera. */
  public final int y;

  /** The z-coordinate (up) of this Camera. */
  public final int z;
  
  /** The x-component of the vector of length '1&lt;&lt;16' in the direction this Camera is looking (the w-axis). The vector must be horizontal (that is, the z-component must be zero). */
  public final int wx;

  /** The y-component of the vector in the direction this Camera is looking. */
  public final int wy;
  
  /** The sine of the angle by which the Camera is rotated clockwise (so the picture is rotated anti-clockwise) times '1&lt;&lt;16'. */
  public final int sin;
  
  /** The cosine of the angle by which the Camera is rotated clockwise (so the picture is rotated anti-clockwise) times '1&lt;&lt;16'. */
  public final int cos;
}
