package org.sc3d.apt.jrider.v1;

/** Represents the angular size and also the size in pixels of a rectangular window through which to view a 3D scene. This is a completely concrete class which exists only for the convenience of grouping its fields. Instances are immutable.
 * <p>Examples:<ul>
 * <li><tt>new Lens(512, 512, 256, 256)</tt> constructs a Lens representing a 512x512 pixel window with a 90 degree field of view in each direction.
 * <li><tt>new Lens(512, 256, 256, 256)</tt> constructs a Lens representing a 512x256 pixel window with a 90 degree field of view horizontally, by only about 53 degrees vertically. It is the middle half of the first example.
 * <li><tt>new Lens(256, 256, 128, 256)</tt> constructs a Lens with the same field of view as the previous example, but squashed into 256x256. To look right, the resulting picture must be stretched horizontally by a factor of two, so that the pixels end up twice as wide as they are high.
 * </ul> */
public final class Lens {
  /** Constructs a Lens, given values for its fields. */
  public Lens(int width, int height, int lensu, int lensv) {
    this.width = width; this.height = height;
    this.lensu = lensu; this.lensv = lensv;
  }
  
  /** The width of the Lens in pixels. */
  public final int width;
  
  /** The height if the Lens in pixels. */
  public final int height;
  
  /** The distance to the screen, measured in units such that the width of a pixel is '1'. Equivalenty, the reciprocal of the angular width of a pixel at the centre of the screen. */
  public final int lensu;
  
  /** The distance to the screen, measured in units such that the height of a pixel is '1'. Equivalently, the reciprocal of the angular height of a pixel at the centre of the scrren. */
  public final int lensv;
}
