package org.sc3d.apt.jrider.v1;

/** Represents a position and velocity. The instantaneous state of a rotating frame of reference is completely specified by an Orientation and a Trajectory together. The Trajectory contains the parts that change if the origin of the frame is moved. */
public class Trajectory {
  /** Constructs a Trajectory given values for its fields. */
  public Trajectory(int x, int y, int z, int vx, int vy, int vz) {
    this.x = x; this.y = y; this.z = z;
    this.vx = vx; this.vy = vy; this.vz = vz;
  }
  
  /** Constructs a Trajectory with zero velocity. */
  public Trajectory(int x, int y, int z) {
    this.x = x; this.y = y; this.z = z;
    this.vx = 0; this.vy = 0; this.vz = 0;
  }
  
  /* New API. */
  
  /** The x-coordinate (north) of the origin, in units such that the size of the landscape is '1&lt;&lt;32' (so 1 metre is '1&lt;&lt;22'). */
  public final int x;

  /** The y-coordinate (east) of the origin. */
  public final int y;

  /** The z-coordinate (up) of the origin. */
  public final int z;
  
  /** The x-component of the velocity of the origin, expressed in the world's frame, in units such that one landscape per millisecond is '1&lt;&lt;32' (so 1 metre per second is '1&lt;&lt;12'). */
  public final int vx;

  /** The y-component of the velocity of the origin. */
  public final int vy;

  /** The z-component of the velocity of the origin. */
  public final int vz;
}
