/*
 * peer.h:
 * Object representing a peer connection.
 *
 * Copyright (c) 2003 Chris Lightfoot. All rights reserved.
 * Email: chris@ex-parrot.com; WWW: http://www.ex-parrot.com/~chris/
 *
 * $Id: peer.h,v 1.2 2003/10/19 01:33:03 chris Exp $
 *
 */

#ifndef __PEER_H_ /* include guard */
#define __PEER_H_

typedef struct peer *peer;

/* peer.c */
peer peer_new(int fd, void *userdata);
void peer_delete(peer p);
void *peer_get_userdata(peer p);
void peer_set_userdata(peer p, void *userdata);
void peer_pre_select(peer p, int *n, fd_set *rd, fd_set *wr, fd_set *ex);
int peer_post_select(peer p, fd_set *rd, fd_set *wr, fd_set *ex);
int peer_write(peer p, const uint8_t *buf, size_t len);
uint8_t *peer_get_data(peer p, size_t *len);
void peer_consume(peer p, const size_t len);
void peer_get_address(peer p, struct sockaddr *a, socklen_t *l);
int peer_error(peer p);
char *peer_string(peer p);

#endif /* __PEER_H_ */
