package org.sc3d.apt.jrider.v1;

import javax.sound.sampled.*;

/** Plays an engine sound continuously, and allows its pitch to be changed. */
public class EngineNoise extends Thread {
  /** Constructs an EngineNoise.
   * @param numChannels the number of different pitches to play simultaneously.
   */
  public EngineNoise(int numChannels) {
    this.numChannels = numChannels;
    this.phase = new int[numChannels];
    this.dPhase = new int[numChannels];
    this.shouldStop = false;
    try {
      this.line = (SourceDataLine)AudioSystem.getLine(new DataLine.Info(
        Class.forName("javax.sound.sampled.SourceDataLine"),
        new AudioFormat(
          SAMPLE_RATE,
          8,
          1,
          true,
          true
        ),
        BUFFER_LENGTH
      ));
      this.line.open();
    }
    catch (ClassNotFoundException e) {}
    catch (LineUnavailableException e) {}
    catch (IllegalArgumentException e) {}
    if (this.line!=null) this.start();
    else System.out.println("Game will play without sound.");
  }
  
  /** Sets the pitch of the engine noise, given the engine speed in revolutions per minute. */
  public void setRevs(int channel, int rpm) {
    this.dPhase[channel] = (int)(rpm * (6*(1<<24)/60/SAMPLE_RATE));
  }
  
  public void shutup() { this.shouldStop = true; }
  
  /* Override things in Thread. */
  
  public void run() {
    this.setPriority(Thread.MAX_PRIORITY);
    this.line.start();
    while (!this.shouldStop) {
      for (int i=0; i<BUF.length; i++) {
        int tot = 0;
        for (int j=0; j<this.numChannels; j++) {
          this.phase[j] += this.dPhase[j];
          tot += WAVE[0xff & (this.phase[j]>>16)];
        }
        BUF[i] = (byte)(tot/this.numChannels);
      }
      this.line.write(BUF, 0, BUF.length);
    }
    this.line.stop();
  }
  
  /* Private. */
  
  private static final float SAMPLE_RATE = 11025;
  private static final int BUFFER_LENGTH = 2048;
  private static final byte[] BUF = new byte[64];
  
  private static final byte[] WAVE = new byte[256];
  static {
    for (int i=0; i<256; i++) WAVE[i] = (byte)((i*(i-255)+64*127+32)>>6);
  }
  private int numChannels;

  private int[] phase, dPhase;
  private boolean shouldStop;
  private SourceDataLine line;
  
  /* Test code. */
  
  public static void main(String[] args) {
    EngineNoise me = new EngineNoise(2);
    for (int i=500; i<5000; i+=10) {
      me.setRevs(0, i);
      me.setRevs(1, i*5/7);
      try { Thread.currentThread().sleep(5); }
      catch (InterruptedException e) {}
    }
    me.shutup();
  }
}
