/*
 * main.c:
 * Main loop.
 *
 * Copyright (c) 2003 Chris Lightfoot. All rights reserved.
 * Email: chris@ex-parrot.com; WWW: http://www.ex-parrot.com/~chris/
 *
 */

static const char rcsid[] = "$Id: main.c,v 1.3 2003/10/19 03:10:23 chris Exp $";

#include <sys/types.h>

#include <errno.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <netinet/in.h>

#include <sys/select.h>

#include "server.h"
#include "util.h"

/* net_loop SERVER
 * Select loop, calling in to SERVER. */
int net_loop(server s) {
    struct timeval tv;
    fd_set rds, wrs, exs;
    int n = 1;
    
    while (1) {
        int m;
        
        tv.tv_sec = 1;
        tv.tv_usec = 0;

        FD_ZERO(&rds);
        FD_ZERO(&wrs);
        FD_ZERO(&exs);

        server_pre_select(s, &n, &rds, &wrs, &exs, &tv);

        if ((m = select(n, &rds, &wrs, &exs, &tv)) == -1) {
            if (errno != EAGAIN) {
                fprintf(stderr, "net_loop: select: %s\n", strerror(errno));
//                return -1;
            }
        } else {
            if (m == 0) FD_ZERO(&rds);
            server_post_select(s, &rds, &wrs, &exs);
        }
    }
}



int main(int argc, char *argv[]) {
    server s;
    struct sockaddr_in sin = {0};
    xsignal(SIGPIPE, SIG_IGN);
    sin.sin_family = AF_INET;
    sin.sin_addr.s_addr = INADDR_ANY;
    sin.sin_port = htons(7001);
    s = server_new(&sin);
    if (!s) {
        fprintf(stderr, "server_new: %s; aborting\n", strerror(errno));
        return 1;
    }
    net_loop(s);
    return 0;
}

