/*
 * server.h:
 * Server object.
 *
 * Copyright (c) 2003 Chris Lightfoot. All rights reserved.
 * Email: chris@ex-parrot.com; WWW: http://www.ex-parrot.com/~chris/
 *
 * $Id: server.h,v 1.2 2003/10/19 01:33:03 chris Exp $
 *
 */

#ifndef __SERVER_H_ /* include guard */
#define __SERVER_H_

typedef struct server *server;

/* server.c */
server server_new(const struct sockaddr_in *addr);
void server_delete(server s);
void server_pre_select(server s, int *n, fd_set *rd, fd_set *wr, fd_set *ex, struct timeval *tv);
int server_post_select(server s, fd_set *rd, fd_set *wr, fd_set *ex);

#endif /* __SERVER_H_ */
