/*
 * util.h:
 * Utility functions and macros.
 *
 * Copyright (c) 2003 Chris Lightfoot. All rights reserved.
 * Email: chris@ex-parrot.com; WWW: http://www.ex-parrot.com/~chris/
 *
 * $Id: util.h,v 1.2 2003/10/19 01:33:03 chris Exp $
 *
 */

#ifndef __UTIL_H_ /* include guard */
#define __UTIL_H_

/* alloc_struct S P
 * Make P point to a new struct S, initialised as if in static storage (like
 * = {0}). */
#define alloc_struct(S, p)  do { struct S as__z = {0}; p = xmalloc(sizeof *p); *p = as__z; } while (0)

/* util.c */
void *xmalloc(size_t n);
void *xcalloc(size_t n, size_t m);
void *xrealloc(void *w, size_t n);
void xfree(void *v);
char *xstrdup(const char *s);
int compare_timevals(const struct timeval *tv1, const struct timeval *tv2);
void subtract_timevals(struct timeval *tv1, const struct timeval *tv2);
void add_milliseconds_to_timeval(struct timeval *tv, const unsigned int ms);
void (*xsignal(int signum, void (*handler)(int)))(int);

#endif /* __UTIL_H_ */
